/**************************************************************************** 

Friends or Foes? Major Trading Partners and the Success of Economic Sanctions

- This code is provided for replication of our statistical analysis 
- Codes for predicted probabilities or PCP values are also available upon request.
- Estimation: MLE of (independent) Strategic probit choice models
- Data: mclean_whang_isq_replication
- Data for the US sanctions are also available upon request. 
- Specification: 

      Sender
      /\
     /  \Target
SQs,SQt /\
       /  \
  CDs,CDt DLs,DLt
       
SQs: constant issue
SQt: not identified because no choice is available for the target
CDs: constant 
CDt: normalized to zero
DLs: lcaprat s_polit2 s_tr_li_100
DLt: constant lcaprat t_polit2 bk_num top5_diff (or top1_diff) sender_top1_pre

Elena McLean and Taehee Whang 
02/27/2009

***********************************************************************/

new; cls;
library maxlik pgraph;             	            @initialize gauss setting for mle@
chdir c:\mclean_whang_ISQ_replication;          @change to directory where dataset is located@

/*********************************************************************************
define dataset and variables
*********************************************************************************/

ds="mclean_whang_20080910";                                    
let dep= y_sq y_cp y_dl;  							@original outcome variable = policy result * sanct contribution: cp if >=9, and dl otherwise @
let ind11= issue;                                                 @regressors: U11@
let ind14= lcaprat s_polit2 s_tr_li_100;                          @regressors: U14@
let ind24= lcaprat t_polit2 bk_num top5_diff sender_top1_pre; 	@regressors: U24: top1_diff is also available in the dataset@
vars=dep|ind11|ind14|ind24;                                       @character vector of labels selected for analysis@

/*********************************************************************************
set maxlik parameters and run maxlik
*********************************************************************************/

_max_parnames="const11"|ind11|"const13"|ind14|"const24"|ind24/*|"lns2"*/; @parameter names for maxlik@
stval=ones(rows(_max_parnames),1).*-0.005+0.0006;				  @initial values@	
_max_covpar=3;                                                            @heteroskad-con std err@
__title="_Strategic probit: Payoff disturbance model_"; 
outfile="Mclean_Whang_ISQ.out";	                                      @output file name@
output file=^outfile reset;                                               @turn output on@
{b_ALL_TOP5_DIFF,logl,g,vc,ret}=maxprt(maxlik(ds,vars,&Sppd,stval));      @run maxlik procedure@
output off;                                                               @turn output off@        
@save b_ALL_TOP5_DIFF,b_ALL_TOP5_DIFF;@						  @you can save the result: remove @'s, and run@	

/********************************************************************************
procedure of likelihood function
********************************************************************************/

proc Sppd(b,data);                                  @proc declaration@
    local y1,y3,y4,x11,x13,x14,x24,b11,b13,b14,b24,s2,p1,p2,p3,p4,llik;@local variable declaration@
    y1=data[.,1];                                   @peel off y=sq@
    y3=data[.,2];                                   @peel off y=cd@
    y4=data[.,3];                                   @peel off y=dl@

    x11=ones(rows(data),1)~data[.,4];               @x11 matrix with constant@
    x13=ones(rows(data),1);                         @x13 only constant@ 
    x14=data[.,5:7];                                @x14 matrix WITHOUT constant -- idenfication@
    x24=ones(rows(data),1)~data[.,8:cols(data)];    @x24 matrix with const@

    b11=b[1:2];                                     @coeff vector for 1's utility of status quo=U1(Y1)@
    b13=b[3];                                       @coeff vector for 1's utility of back-down=U1(Y3)@ 
    b14=b[4:6];                                     @coeff vector for 1's utility of deadlock=U1(Y4)@
    b24=b[7:rows(b)];                               @coeff vector for 2's utility of deadlock=U2(Y4)@     
    s2=1;    

    p3=cdfn(-x24*b24./sqrt(s2));                    @equil prob that 2 concedes@
    p4=cdfn(x24*b24./sqrt(s2));                     @equil prob that 2 resists@
    p1=cdfn((x11*b11-p3.*x13*b13-p4.*x14*b14)./sqrt(s2*(1+p3.^2+p4.^2))); @equil prob that 1 not sanctions@
    p2=1-p1;                                        @equil prob that 1 sanctions@
    
    llik=y1.*ln(p1) + y3.*ln(p2.*p3) + y4.*ln(p2.*p4); @log-likelihood function@
    retp(llik);                                @return llik vector@
endp;   

end;
